package img;

import java.awt.Color;

/**
 * Filtre : transformation définie par une matrice de convolution.
 * <p>
 * 
 * Chaque pixel est transformé en fonction de sa valeur, de son voisinage et
 * d'un masque (matrice de convolution).
 */
public class Masque extends Filtre {
	
	//-------------------------
	// Attributs statiques
	//-------------------------

	/**
	 * Matrice de convolution prédéfinie pour réhausser les contours de l'image.
	 */
	public static final double[][] REHAUSSEUR = {
			{  0, -1,  0 }, 
			{ -1,  5, -1 }, 
			{  0, -1,  0 }
	};

	/**
	 * Matrice de convolution prédéfinie pour détecter les contours de l'image.
	 */
	public static final double[][] CONTOURS = {
			{ 0,  1, 0 }, 
			{ 1, -4, 1 }, 
			{ 0,  1, 0 }
	};

	/**
	 * Matrice de convolution prédéfinie pour flouter l'image.
	 */
	public static final double[][] FLOU1 = { 
			{ 1./9, 1./9, 1./9 }, 
			{ 1./9, 1./9, 1./9 },
			{ 1./9, 1./9, 1./9 } 
	};

	/**
	 * Matrice de convolution prédéfinie pour flouter davantage l'image.
	 */
	public static final double[][] FLOU2 = { 
			{ 1./25, 1./25, 1./25, 1./25, 1./25 },
			{ 1./25, 1./25, 1./25, 1./25, 1./25 }, 
			{ 1./25, 1./25, 1./25, 1./25, 1./25 },
			{ 1./25, 1./25, 1./25, 1./25, 1./25 },
			{ 1./25, 1./25, 1./25, 1./25, 1./25 } 
	};
	
	//-------------------------
	// Membres non-statiques
	//-------------------------

	/**
	 * Amplificateur.
	 */
	protected int ampli;
	
	/**
	 * Matrice de convolution.
	 */
	protected double[][] masque;

	/**
	 * Constructeur : initialise le masque et l'amplificateur.
	 * @param masque masque
	 * @param ampli amplificateur
	 */
	public Masque(double[][] masque, int ampli) {
		this.masque = masque;
		this.ampli  = ampli;
	}
	
	/**
	 * Constructeur avec amplificateur par défaut de 1.
	 * @param masque masque
	 */
	public Masque(double[][] masque) {
		this(masque, 1);
	}

	/**
	 * Extrait un pixel d'un tableau y compris lorsque ses coordonnées sont hors
	 * bornes.
	 * <p>
	 * Lorsqu'une coordonnée dépasse un bord, sa valeur symétrique par rapport à ce
	 * bord est prise en compte à la place.
	 * 
	 * @param pixels tableau contenant le pixel à extraire
	 * @param x      abscisse du pixel à extraire
	 * @param y      ordonnée du pixel à extraire
	 * @return pixel extrait
	 */
	@SuppressWarnings("unused") // <- TODO à supprimer quand getPix est appelé
	private Color getPix(Color[][] pixels, int y, int x) {
		// TODO EXERCICE 6 : à compléter...
		return null; // <- TODO résultat à adapter
	}	
	
	/**
	 * Applique l'opérateur de convolution correspondant au masque.
	 * <p>
	 * Le pixel transformé est extrait du tableau de pixel fourni. Le résultat de la
	 * transformation dépend de ce pixel et de son voisinage. Il consiste à faire la
	 * somme de toutes les valeurs qui environnent le pixel selon la taille du
	 * masque en appliquant sur chaque valeur le coefficient de pondération
	 * correspondant dans le masque. Les valeurs environnantes sont obtenues grâce à
	 * getPix.
	 * 
	 * @param pixels tableau contenant le pixel à transformer
	 * @param x      abscisse du pixel à transformer
	 * @param y      ordonnée du pixel à transformer
	 * @return pixel transformé
	 */
	@Override
	protected Color transformePixel(Color[][] pixels, int y, int x) {
		// TODO EXERCICE 6 : à compléter...
		return null; // <- TODO résultat à adapter
	}

}
